(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     74954,       2119]
NotebookOptionsPosition[     73035,       2049]
NotebookOutlinePosition[     73390,       2065]
CellTagsIndexPosition[     73347,       2062]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "*", 
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"u", "*", "t"}]}], ")"}]}], "\[Equal]", 
     RowBox[{
      RowBox[{"v", "*", "t"}], "-", 
      RowBox[{
       RowBox[{"1", "/", "2"}], "g", "*", 
       RowBox[{"t", "^", "2"}]}]}]}], "}"}], ",", 
   RowBox[{"{", "t", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.672018256940401*^9, 3.6720183348640757`*^9}, {
  3.672018373907158*^9, 3.672018395511936*^9}, {3.672018429105364*^9, 
  3.672018462900762*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "k"}], " ", "u"}], "+", "v", "-", 
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
         RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "g"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "k"}], " ", "u"}], "+", "v", "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
         RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "g"]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.672018310350831*^9, 3.6720183386479893`*^9}, 
   3.672018398497849*^9, 3.6720184662962713`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"y", "=", 
  RowBox[{"k", 
   RowBox[{"(", 
    RowBox[{"x", "+", 
     RowBox[{"u", "*", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "k"}], " ", "u"}], "+", "v", "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
          RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "g"]}]}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{
  3.6720187158233337`*^9, {3.672018781133292*^9, 3.672018803286654*^9}}],

Cell[BoxData[
 RowBox[{"k", " ", 
  RowBox[{"(", 
   RowBox[{"x", "+", 
    FractionBox[
     RowBox[{"u", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "k"}], " ", "u"}], "+", "v", "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
          RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], ")"}]}], "g"]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.672018811569572*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", "1", "]"}], "=", 
  RowBox[{"v", "-", 
   RowBox[{"g", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "k"}], " ", "u"}], "+", "v", "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
        RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "g"]}]}]}]], "Input",\

 CellChangeTimes->{{3.6720188171439123`*^9, 3.672018829833383*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"k", " ", "u"}], "+", 
  SqrtBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
    RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}]], "Output",
 CellChangeTimes->{3.672018833217895*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"us", "-", 
       RowBox[{
        RowBox[{"v", "[", "1", "]"}], "c"}]}], "\[Equal]", "\[Xi]"}], ",", 
     RowBox[{
      RowBox[{"uc", "+", 
       RowBox[{
        RowBox[{"v", "[", "1", "]"}], "s"}]}], "\[Equal]", 
      "\[FinalSigma]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Xi]", ",", "\[FinalSigma]"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.672018852714576*^9, 3.672019014970145*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Xi]", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "c"}], " ", "k", " ", "u"}], "+", "us", "-", 
      RowBox[{"c", " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
         RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}]}]}], ",", 
    RowBox[{"\[FinalSigma]", "\[Rule]", 
     RowBox[{
      RowBox[{"k", " ", "s", " ", "u"}], "+", "uc", "+", 
      RowBox[{"s", " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
         RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}]}]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6720190190709457`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"\[Xi]", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "c"}], " ", "k", " ", "u"}], "+", "us", "-", 
   RowBox[{"c", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
      RowBox[{
      "2", " ", "g", " ", "k", " ", "x"}]}]]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"\[FinalSigma]", "=", 
  RowBox[{
   RowBox[{"k", " ", "s", " ", "u"}], "+", "uc", "+", 
   RowBox[{"s", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
      RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}]}]}]}], "Input",
 CellChangeTimes->{{3.672019034187385*^9, 3.672019062973887*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "c"}], " ", "k", " ", "u"}], "+", "us", "-", 
  RowBox[{"c", " ", 
   SqrtBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
     RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}]}]], "Output",
 CellChangeTimes->{3.6720190667935*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"k", " ", "s", " ", "u"}], "+", "uc", "+", 
  RowBox[{"s", " ", 
   SqrtBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
     RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}]}]], "Output",
 CellChangeTimes->{3.672019066795977*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[CapitalXi]", "\[Equal]", 
      RowBox[{
       RowBox[{"-", "\[Xi]"}], "*", "\[Beta]"}]}], ",", 
     RowBox[{
      RowBox[{"\[CapitalSigma]", "-", 
       RowBox[{"a", "*", "W"}]}], "\[Equal]", 
      RowBox[{
       RowBox[{"-", "\[Alpha]"}], 
       RowBox[{"(", 
        RowBox[{"\[FinalSigma]", "-", "aw"}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "a", "*", "W"}], "+", 
       RowBox[{"5", "\[CapitalSigma]"}]}], "\[Equal]", 
      RowBox[{
       RowBox[{"5", "\[FinalSigma]"}], "+", 
       RowBox[{"2", "aw"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"W", ",", "\[CapitalSigma]", ",", "\[CapitalXi]"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.672019070788711*^9, 3.672019234451605*^9}, {
  3.672019316813418*^9, 3.672019332970107*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"W", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "aw"}], "-", 
        RowBox[{"5", " ", "k", " ", "s", " ", "u"}], "-", 
        RowBox[{"5", " ", "uc"}], "-", 
        RowBox[{"5", " ", "s", " ", 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
           RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "+", 
        RowBox[{"5", " ", "aw", " ", "\[Alpha]"}], "-", 
        RowBox[{"5", " ", "k", " ", "s", " ", "u", " ", "\[Alpha]"}], "-", 
        RowBox[{"5", " ", "uc", " ", "\[Alpha]"}], "-", 
        RowBox[{"5", " ", "s", " ", 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
           RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
         "\[Alpha]"}]}], 
       RowBox[{"7", " ", "a"}]]}]}], ",", 
    RowBox[{"\[CapitalSigma]", "\[Rule]", 
     RowBox[{
      FractionBox["1", "7"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "aw"}], "+", 
        RowBox[{"5", " ", "k", " ", "s", " ", "u"}], "+", 
        RowBox[{"5", " ", "uc"}], "+", 
        RowBox[{"5", " ", "s", " ", 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
           RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "+", 
        RowBox[{"2", " ", "aw", " ", "\[Alpha]"}], "-", 
        RowBox[{"2", " ", "k", " ", "s", " ", "u", " ", "\[Alpha]"}], "-", 
        RowBox[{"2", " ", "uc", " ", "\[Alpha]"}], "-", 
        RowBox[{"2", " ", "s", " ", 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
           RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
         "\[Alpha]"}]}], ")"}]}]}], ",", 
    RowBox[{"\[CapitalXi]", "\[Rule]", 
     RowBox[{
      RowBox[{"c", " ", "k", " ", "u", " ", "\[Beta]"}], "-", 
      RowBox[{"us", " ", "\[Beta]"}], "+", 
      RowBox[{"c", " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
         RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
       "\[Beta]"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.672019238832077*^9, {3.67201932992782*^9, 3.6720193359126387`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"w", "[", "1", "]"}], "=", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "aw"}], "-", 
     RowBox[{"5", " ", "k", " ", "s", " ", "u"}], "-", 
     RowBox[{"5", " ", "uc"}], "-", 
     RowBox[{"5", " ", "s", " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
        RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "+", 
     RowBox[{"5", " ", "aw", " ", "\[Alpha]"}], "-", 
     RowBox[{"5", " ", "k", " ", "s", " ", "u", " ", "\[Alpha]"}], "-", 
     RowBox[{"5", " ", "uc", " ", "\[Alpha]"}], "-", 
     RowBox[{"5", " ", "s", " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
        RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Alpha]"}]}], 
    RowBox[{"7", " ", "a"}]]}]}], "\[IndentingNewLine]", 
 RowBox[{"\[CapitalSigma]", "=", 
  RowBox[{
   FractionBox["1", "7"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "aw"}], "+", 
     RowBox[{"5", " ", "k", " ", "s", " ", "u"}], "+", 
     RowBox[{"5", " ", "uc"}], "+", 
     RowBox[{"5", " ", "s", " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
        RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "+", 
     RowBox[{"2", " ", "aw", " ", "\[Alpha]"}], "-", 
     RowBox[{"2", " ", "k", " ", "s", " ", "u", " ", "\[Alpha]"}], "-", 
     RowBox[{"2", " ", "uc", " ", "\[Alpha]"}], "-", 
     RowBox[{"2", " ", "s", " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
        RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Alpha]"}]}], 
    ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"\[CapitalXi]", "=", 
  RowBox[{
   RowBox[{"c", " ", "k", " ", "u", " ", "\[Beta]"}], "-", 
   RowBox[{"us", " ", "\[Beta]"}], "+", 
   RowBox[{"c", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
      RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
    "\[Beta]"}]}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6720192476174917`*^9, 3.672019306353488*^9}, {
  3.672019345510825*^9, 3.672019353485718*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "aw"}], "-", 
    RowBox[{"5", " ", "k", " ", "s", " ", "u"}], "-", 
    RowBox[{"5", " ", "uc"}], "-", 
    RowBox[{"5", " ", "s", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
       RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "+", 
    RowBox[{"5", " ", "aw", " ", "\[Alpha]"}], "-", 
    RowBox[{"5", " ", "k", " ", "s", " ", "u", " ", "\[Alpha]"}], "-", 
    RowBox[{"5", " ", "uc", " ", "\[Alpha]"}], "-", 
    RowBox[{"5", " ", "s", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
       RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Alpha]"}]}], 
   RowBox[{"7", " ", "a"}]]}]], "Output",
 CellChangeTimes->{3.672019356112288*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "7"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", "aw"}], "+", 
    RowBox[{"5", " ", "k", " ", "s", " ", "u"}], "+", 
    RowBox[{"5", " ", "uc"}], "+", 
    RowBox[{"5", " ", "s", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
       RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "+", 
    RowBox[{"2", " ", "aw", " ", "\[Alpha]"}], "-", 
    RowBox[{"2", " ", "k", " ", "s", " ", "u", " ", "\[Alpha]"}], "-", 
    RowBox[{"2", " ", "uc", " ", "\[Alpha]"}], "-", 
    RowBox[{"2", " ", "s", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
       RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Alpha]"}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.672019356115067*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"c", " ", "k", " ", "u", " ", "\[Beta]"}], "-", 
  RowBox[{"us", " ", "\[Beta]"}], "+", 
  RowBox[{"c", " ", 
   SqrtBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
     RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
   "\[Beta]"}]}]], "Output",
 CellChangeTimes->{3.6720193561178093`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"\[Theta]", "*", "s"}], "-", 
        RowBox[{"\[Omega]", "*", "c"}]}], "\[Equal]", "\[CapitalXi]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Theta]", "*", "c"}], "+", 
        RowBox[{"\[Omega]", "*", "s"}]}], "\[Equal]", "\[CapitalSigma]"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", "\[Omega]"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.67201980870487*^9, 3.6720199453607197`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Theta]", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "aw", " ", "c"}], "-", 
        RowBox[{"5", " ", "c", " ", "k", " ", "s", " ", "u"}], "-", 
        RowBox[{"5", " ", "c", " ", "uc"}], "-", 
        RowBox[{"5", " ", "c", " ", "s", " ", 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
           RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "-", 
        RowBox[{"2", " ", "aw", " ", "c", " ", "\[Alpha]"}], "+", 
        RowBox[{
        "2", " ", "c", " ", "k", " ", "s", " ", "u", " ", "\[Alpha]"}], "+", 
        RowBox[{"2", " ", "c", " ", "uc", " ", "\[Alpha]"}], "+", 
        RowBox[{"2", " ", "c", " ", "s", " ", 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
           RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Alpha]"}], 
        "-", 
        RowBox[{"7", " ", "c", " ", "k", " ", "s", " ", "u", " ", "\[Beta]"}],
         "+", 
        RowBox[{"7", " ", "s", " ", "us", " ", "\[Beta]"}], "-", 
        RowBox[{"7", " ", "c", " ", "s", " ", 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
           RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Beta]"}]}], 
       RowBox[{"7", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["c", "2"], "+", 
          SuperscriptBox["s", "2"]}], ")"}]}]]}]}], ",", 
    RowBox[{"\[Omega]", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "aw", " ", "s"}], "-", 
        RowBox[{"5", " ", "k", " ", 
         SuperscriptBox["s", "2"], " ", "u"}], "-", 
        RowBox[{"5", " ", "s", " ", "uc"}], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["s", "2"], " ", 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
           RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "-", 
        RowBox[{"2", " ", "aw", " ", "s", " ", "\[Alpha]"}], "+", 
        RowBox[{"2", " ", "k", " ", 
         SuperscriptBox["s", "2"], " ", "u", " ", "\[Alpha]"}], "+", 
        RowBox[{"2", " ", "s", " ", "uc", " ", "\[Alpha]"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["s", "2"], " ", 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
           RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Alpha]"}], 
        "+", 
        RowBox[{"7", " ", 
         SuperscriptBox["c", "2"], " ", "k", " ", "u", " ", "\[Beta]"}], "-", 
        
        RowBox[{"7", " ", "c", " ", "us", " ", "\[Beta]"}], "+", 
        RowBox[{"7", " ", 
         SuperscriptBox["c", "2"], " ", 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
           RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Beta]"}]}], 
       RowBox[{"7", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["c", "2"], "+", 
          SuperscriptBox["s", "2"]}], ")"}]}]]}]}]}], "}"}], "}"}]], "Output",\

 CellChangeTimes->{3.6720199107754908`*^9, 3.67201994850382*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "[", "2", "]"}], "=", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "aw", " ", "c"}], "-", 
     RowBox[{"5", " ", "c", " ", "k", " ", "s", " ", "u"}], "-", 
     RowBox[{"5", " ", "c", " ", "uc"}], "-", 
     RowBox[{"5", " ", "c", " ", "s", " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
        RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "-", 
     RowBox[{"2", " ", "aw", " ", "c", " ", "\[Alpha]"}], "+", 
     RowBox[{"2", " ", "c", " ", "k", " ", "s", " ", "u", " ", "\[Alpha]"}], 
     "+", 
     RowBox[{"2", " ", "c", " ", "uc", " ", "\[Alpha]"}], "+", 
     RowBox[{"2", " ", "c", " ", "s", " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
        RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Alpha]"}], 
     "-", 
     RowBox[{"7", " ", "c", " ", "k", " ", "s", " ", "u", " ", "\[Beta]"}], 
     "+", 
     RowBox[{"7", " ", "s", " ", "us", " ", "\[Beta]"}], "-", 
     RowBox[{"7", " ", "c", " ", "s", " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
        RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Beta]"}]}], 
    RowBox[{"7", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["c", "2"], "+", 
       SuperscriptBox["s", "2"]}], ")"}]}]]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v", "[", "2", "]"}], "=", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "aw", " ", "s"}], "-", 
     RowBox[{"5", " ", "k", " ", 
      SuperscriptBox["s", "2"], " ", "u"}], "-", 
     RowBox[{"5", " ", "s", " ", "uc"}], "-", 
     RowBox[{"5", " ", 
      SuperscriptBox["s", "2"], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
        RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "-", 
     RowBox[{"2", " ", "aw", " ", "s", " ", "\[Alpha]"}], "+", 
     RowBox[{"2", " ", "k", " ", 
      SuperscriptBox["s", "2"], " ", "u", " ", "\[Alpha]"}], "+", 
     RowBox[{"2", " ", "s", " ", "uc", " ", "\[Alpha]"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["s", "2"], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
        RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Alpha]"}], 
     "+", 
     RowBox[{"7", " ", 
      SuperscriptBox["c", "2"], " ", "k", " ", "u", " ", "\[Beta]"}], "-", 
     RowBox[{"7", " ", "c", " ", "us", " ", "\[Beta]"}], "+", 
     RowBox[{"7", " ", 
      SuperscriptBox["c", "2"], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
        RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Beta]"}]}], 
    RowBox[{"7", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["c", "2"], "+", 
       SuperscriptBox["s", "2"]}], ")"}]}]]}]}]}], "Input",
 CellChangeTimes->{{3.672019984156184*^9, 3.672020004922894*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "aw", " ", "c"}], "-", 
    RowBox[{"5", " ", "c", " ", "k", " ", "s", " ", "u"}], "-", 
    RowBox[{"5", " ", "c", " ", "uc"}], "-", 
    RowBox[{"5", " ", "c", " ", "s", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
       RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "-", 
    RowBox[{"2", " ", "aw", " ", "c", " ", "\[Alpha]"}], "+", 
    RowBox[{"2", " ", "c", " ", "k", " ", "s", " ", "u", " ", "\[Alpha]"}], 
    "+", 
    RowBox[{"2", " ", "c", " ", "uc", " ", "\[Alpha]"}], "+", 
    RowBox[{"2", " ", "c", " ", "s", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
       RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Alpha]"}], "-", 
    RowBox[{"7", " ", "c", " ", "k", " ", "s", " ", "u", " ", "\[Beta]"}], 
    "+", 
    RowBox[{"7", " ", "s", " ", "us", " ", "\[Beta]"}], "-", 
    RowBox[{"7", " ", "c", " ", "s", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
       RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Beta]"}]}], 
   RowBox[{"7", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["c", "2"], "+", 
      SuperscriptBox["s", "2"]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{3.672020021849025*^9}],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "aw", " ", "s"}], "-", 
    RowBox[{"5", " ", "k", " ", 
     SuperscriptBox["s", "2"], " ", "u"}], "-", 
    RowBox[{"5", " ", "s", " ", "uc"}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["s", "2"], " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
       RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "-", 
    RowBox[{"2", " ", "aw", " ", "s", " ", "\[Alpha]"}], "+", 
    RowBox[{"2", " ", "k", " ", 
     SuperscriptBox["s", "2"], " ", "u", " ", "\[Alpha]"}], "+", 
    RowBox[{"2", " ", "s", " ", "uc", " ", "\[Alpha]"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["s", "2"], " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
       RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Alpha]"}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["c", "2"], " ", "k", " ", "u", " ", "\[Beta]"}], "-", 
    RowBox[{"7", " ", "c", " ", "us", " ", "\[Beta]"}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["c", "2"], " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
       RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Beta]"}]}], 
   RowBox[{"7", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["c", "2"], "+", 
      SuperscriptBox["s", "2"]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{3.672020021853058*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{"g", " ", 
         SuperscriptBox["t", "2"]}], ")"}]}], "+", 
      RowBox[{"t", " ", 
       RowBox[{"v", "[", "2", "]"}]}], "+", "y"}], "\[Equal]", "0"}], "}"}], 
   ",", 
   RowBox[{"{", "t", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.672020118232335*^9, 3.672020246264011*^9}, {
  3.672020277952836*^9, 3.6720203099479523`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{
       FractionBox["1", "g"], 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", "aw", " ", "s"}], "-", 
           RowBox[{"5", " ", "k", " ", 
            SuperscriptBox["s", "2"], " ", "u"}], "-", 
           RowBox[{"5", " ", "s", " ", "uc"}], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["s", "2"], " ", 
            SqrtBox[
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
              RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "-", 
           RowBox[{"2", " ", "aw", " ", "s", " ", "\[Alpha]"}], "+", 
           RowBox[{"2", " ", "k", " ", 
            SuperscriptBox["s", "2"], " ", "u", " ", "\[Alpha]"}], "+", 
           RowBox[{"2", " ", "s", " ", "uc", " ", "\[Alpha]"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["s", "2"], " ", 
            SqrtBox[
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
              RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
            "\[Alpha]"}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["c", "2"], " ", "k", " ", "u", " ", "\[Beta]"}], 
           "-", 
           RowBox[{"7", " ", "c", " ", "us", " ", "\[Beta]"}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["c", "2"], " ", 
            SqrtBox[
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
              RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
            "\[Beta]"}]}], 
          RowBox[{"7", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["c", "2"], "+", 
             SuperscriptBox["s", "2"]}], ")"}]}]], "-", 
         RowBox[{"\[Sqrt]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "k", " ", 
             RowBox[{"(", 
              RowBox[{"x", "+", 
               FractionBox[
                RowBox[{"u", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "k"}], " ", "u"}], "+", "v", "-", 
                   SqrtBox[
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
                    RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], ")"}]}],
                 "g"]}], ")"}]}], "+", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], " ", "aw", " ", "s"}], "-", 
                RowBox[{"5", " ", "k", " ", 
                 SuperscriptBox["s", "2"], " ", "u"}], "-", 
                RowBox[{"5", " ", "s", " ", "uc"}], "-", 
                RowBox[{"5", " ", 
                 SuperscriptBox["s", "2"], " ", 
                 SqrtBox[
                  RowBox[{
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
                   RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "-", 
                RowBox[{"2", " ", "aw", " ", "s", " ", "\[Alpha]"}], "+", 
                RowBox[{"2", " ", "k", " ", 
                 SuperscriptBox["s", "2"], " ", "u", " ", "\[Alpha]"}], "+", 
                RowBox[{"2", " ", "s", " ", "uc", " ", "\[Alpha]"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["s", "2"], " ", 
                 SqrtBox[
                  RowBox[{
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
                   RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
                 "\[Alpha]"}], "+", 
                RowBox[{"7", " ", 
                 SuperscriptBox["c", "2"], " ", "k", " ", "u", " ", 
                 "\[Beta]"}], "-", 
                RowBox[{"7", " ", "c", " ", "us", " ", "\[Beta]"}], "+", 
                RowBox[{"7", " ", 
                 SuperscriptBox["c", "2"], " ", 
                 SqrtBox[
                  RowBox[{
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
                   RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
                 "\[Beta]"}]}], ")"}], "2"], 
             RowBox[{"49", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["c", "2"], "+", 
                 SuperscriptBox["s", "2"]}], ")"}], "2"]}]]}], ")"}]}]}], 
        ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{
       FractionBox["1", "g"], 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", "aw", " ", "s"}], "-", 
           RowBox[{"5", " ", "k", " ", 
            SuperscriptBox["s", "2"], " ", "u"}], "-", 
           RowBox[{"5", " ", "s", " ", "uc"}], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["s", "2"], " ", 
            SqrtBox[
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
              RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "-", 
           RowBox[{"2", " ", "aw", " ", "s", " ", "\[Alpha]"}], "+", 
           RowBox[{"2", " ", "k", " ", 
            SuperscriptBox["s", "2"], " ", "u", " ", "\[Alpha]"}], "+", 
           RowBox[{"2", " ", "s", " ", "uc", " ", "\[Alpha]"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["s", "2"], " ", 
            SqrtBox[
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
              RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
            "\[Alpha]"}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["c", "2"], " ", "k", " ", "u", " ", "\[Beta]"}], 
           "-", 
           RowBox[{"7", " ", "c", " ", "us", " ", "\[Beta]"}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["c", "2"], " ", 
            SqrtBox[
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
              RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
            "\[Beta]"}]}], 
          RowBox[{"7", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["c", "2"], "+", 
             SuperscriptBox["s", "2"]}], ")"}]}]], "+", 
         RowBox[{"\[Sqrt]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "g", " ", "k", " ", 
             RowBox[{"(", 
              RowBox[{"x", "+", 
               FractionBox[
                RowBox[{"u", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "k"}], " ", "u"}], "+", "v", "-", 
                   SqrtBox[
                    RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
                    RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], ")"}]}],
                 "g"]}], ")"}]}], "+", 
            FractionBox[
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], " ", "aw", " ", "s"}], "-", 
                RowBox[{"5", " ", "k", " ", 
                 SuperscriptBox["s", "2"], " ", "u"}], "-", 
                RowBox[{"5", " ", "s", " ", "uc"}], "-", 
                RowBox[{"5", " ", 
                 SuperscriptBox["s", "2"], " ", 
                 SqrtBox[
                  RowBox[{
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
                   RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "-", 
                RowBox[{"2", " ", "aw", " ", "s", " ", "\[Alpha]"}], "+", 
                RowBox[{"2", " ", "k", " ", 
                 SuperscriptBox["s", "2"], " ", "u", " ", "\[Alpha]"}], "+", 
                RowBox[{"2", " ", "s", " ", "uc", " ", "\[Alpha]"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["s", "2"], " ", 
                 SqrtBox[
                  RowBox[{
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
                   RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
                 "\[Alpha]"}], "+", 
                RowBox[{"7", " ", 
                 SuperscriptBox["c", "2"], " ", "k", " ", "u", " ", 
                 "\[Beta]"}], "-", 
                RowBox[{"7", " ", "c", " ", "us", " ", "\[Beta]"}], "+", 
                RowBox[{"7", " ", 
                 SuperscriptBox["c", "2"], " ", 
                 SqrtBox[
                  RowBox[{
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
                   RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
                 "\[Beta]"}]}], ")"}], "2"], 
             RowBox[{"49", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["c", "2"], "+", 
                 SuperscriptBox["s", "2"]}], ")"}], "2"]}]]}], ")"}]}]}], 
        ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.672020281816625*^9, 3.672020312545623*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "g"]}], 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "aw", " ", "s"}], "-", 
       RowBox[{"5", " ", "k", " ", 
        SuperscriptBox["s", "2"], " ", "u"}], "-", 
       RowBox[{"5", " ", "s", " ", "uc"}], "-", 
       RowBox[{"5", " ", 
        SuperscriptBox["s", "2"], " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
          RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "-", 
       RowBox[{"2", " ", "aw", " ", "s", " ", "\[Alpha]"}], "+", 
       RowBox[{"2", " ", "k", " ", 
        SuperscriptBox["s", "2"], " ", "u", " ", "\[Alpha]"}], "+", 
       RowBox[{"2", " ", "s", " ", "uc", " ", "\[Alpha]"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["s", "2"], " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
          RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Alpha]"}], 
       "+", 
       RowBox[{"7", " ", 
        SuperscriptBox["c", "2"], " ", "k", " ", "u", " ", "\[Beta]"}], "-", 
       RowBox[{"7", " ", "c", " ", "us", " ", "\[Beta]"}], "+", 
       RowBox[{"7", " ", 
        SuperscriptBox["c", "2"], " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
          RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Beta]"}]}], 
      
      RowBox[{"7", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         SuperscriptBox["s", "2"]}], ")"}]}]], "-", 
     RowBox[{"\[Sqrt]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "g", " ", "k", " ", 
         RowBox[{"(", 
          RowBox[{"x", "+", 
           FractionBox[
            RowBox[{"u", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "k"}], " ", "u"}], "+", "v", "-", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
                 RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], ")"}]}], 
            "g"]}], ")"}]}], "+", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "aw", " ", "s"}], "-", 
            RowBox[{"5", " ", "k", " ", 
             SuperscriptBox["s", "2"], " ", "u"}], "-", 
            RowBox[{"5", " ", "s", " ", "uc"}], "-", 
            RowBox[{"5", " ", 
             SuperscriptBox["s", "2"], " ", 
             SqrtBox[
              RowBox[{
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
               RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "-", 
            RowBox[{"2", " ", "aw", " ", "s", " ", "\[Alpha]"}], "+", 
            RowBox[{"2", " ", "k", " ", 
             SuperscriptBox["s", "2"], " ", "u", " ", "\[Alpha]"}], "+", 
            RowBox[{"2", " ", "s", " ", "uc", " ", "\[Alpha]"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["s", "2"], " ", 
             SqrtBox[
              RowBox[{
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
               RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
             "\[Alpha]"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["c", "2"], " ", "k", " ", "u", " ", "\[Beta]"}], 
            "-", 
            RowBox[{"7", " ", "c", " ", "us", " ", "\[Beta]"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["c", "2"], " ", 
             SqrtBox[
              RowBox[{
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
               RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
             "\[Beta]"}]}], ")"}], "2"], 
         RowBox[{"49", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["c", "2"], "+", 
             SuperscriptBox["s", "2"]}], ")"}], "2"]}]]}], ")"}]}]}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.672020434059929*^9, 3.6720204363162537`*^9}}],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", "g"], 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "aw", " ", "s"}], "-", 
       RowBox[{"5", " ", "k", " ", 
        SuperscriptBox["s", "2"], " ", "u"}], "-", 
       RowBox[{"5", " ", "s", " ", "uc"}], "-", 
       RowBox[{"5", " ", 
        SuperscriptBox["s", "2"], " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
          RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "-", 
       RowBox[{"2", " ", "aw", " ", "s", " ", "\[Alpha]"}], "+", 
       RowBox[{"2", " ", "k", " ", 
        SuperscriptBox["s", "2"], " ", "u", " ", "\[Alpha]"}], "+", 
       RowBox[{"2", " ", "s", " ", "uc", " ", "\[Alpha]"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["s", "2"], " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
          RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Alpha]"}], 
       "+", 
       RowBox[{"7", " ", 
        SuperscriptBox["c", "2"], " ", "k", " ", "u", " ", "\[Beta]"}], "-", 
       RowBox[{"7", " ", "c", " ", "us", " ", "\[Beta]"}], "+", 
       RowBox[{"7", " ", 
        SuperscriptBox["c", "2"], " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
          RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Beta]"}]}], 
      
      RowBox[{"7", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         SuperscriptBox["s", "2"]}], ")"}]}]], "-", 
     RowBox[{"\[Sqrt]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "g", " ", "k", " ", 
         RowBox[{"(", 
          RowBox[{"x", "+", 
           FractionBox[
            RowBox[{"u", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "k"}], " ", "u"}], "+", "v", "-", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
                 RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], ")"}]}], 
            "g"]}], ")"}]}], "+", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "aw", " ", "s"}], "-", 
            RowBox[{"5", " ", "k", " ", 
             SuperscriptBox["s", "2"], " ", "u"}], "-", 
            RowBox[{"5", " ", "s", " ", "uc"}], "-", 
            RowBox[{"5", " ", 
             SuperscriptBox["s", "2"], " ", 
             SqrtBox[
              RowBox[{
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
               RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "-", 
            RowBox[{"2", " ", "aw", " ", "s", " ", "\[Alpha]"}], "+", 
            RowBox[{"2", " ", "k", " ", 
             SuperscriptBox["s", "2"], " ", "u", " ", "\[Alpha]"}], "+", 
            RowBox[{"2", " ", "s", " ", "uc", " ", "\[Alpha]"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["s", "2"], " ", 
             SqrtBox[
              RowBox[{
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
               RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
             "\[Alpha]"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["c", "2"], " ", "k", " ", "u", " ", "\[Beta]"}], 
            "-", 
            RowBox[{"7", " ", "c", " ", "us", " ", "\[Beta]"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["c", "2"], " ", 
             SqrtBox[
              RowBox[{
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
               RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
             "\[Beta]"}]}], ")"}], "2"], 
         RowBox[{"49", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["c", "2"], "+", 
             SuperscriptBox["s", "2"]}], ")"}], "2"]}]]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{3.672020441590065*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"X", "=", 
  RowBox[{
   RowBox[{"y", "/", "k"}], "+", 
   RowBox[{
    RowBox[{"u", "[", "2", "]"}], "*", "t"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v", "[", "3", "]"}], "=", 
  RowBox[{
   RowBox[{"v", "[", "2", "]"}], "-", 
   RowBox[{"g", "*", "t"}]}]}]}], "Input",
 CellChangeTimes->{{3.672020444335844*^9, 3.672020469980929*^9}}],

Cell[BoxData[
 RowBox[{"x", "+", 
  FractionBox[
   RowBox[{"u", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "k"}], " ", "u"}], "+", "v", "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
        RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], ")"}]}], "g"], "+", 
  
  RowBox[{
   FractionBox["1", 
    RowBox[{"7", " ", "g", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["c", "2"], "+", 
       SuperscriptBox["s", "2"]}], ")"}]}]], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "aw", " ", "c"}], "-", 
      RowBox[{"5", " ", "c", " ", "k", " ", "s", " ", "u"}], "-", 
      RowBox[{"5", " ", "c", " ", "uc"}], "-", 
      RowBox[{"5", " ", "c", " ", "s", " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
         RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "-", 
      RowBox[{"2", " ", "aw", " ", "c", " ", "\[Alpha]"}], "+", 
      RowBox[{"2", " ", "c", " ", "k", " ", "s", " ", "u", " ", "\[Alpha]"}], 
      "+", 
      RowBox[{"2", " ", "c", " ", "uc", " ", "\[Alpha]"}], "+", 
      RowBox[{"2", " ", "c", " ", "s", " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
         RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Alpha]"}], 
      "-", 
      RowBox[{"7", " ", "c", " ", "k", " ", "s", " ", "u", " ", "\[Beta]"}], 
      "+", 
      RowBox[{"7", " ", "s", " ", "us", " ", "\[Beta]"}], "-", 
      RowBox[{"7", " ", "c", " ", "s", " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
         RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Beta]"}]}], 
     ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "aw", " ", "s"}], "-", 
        RowBox[{"5", " ", "k", " ", 
         SuperscriptBox["s", "2"], " ", "u"}], "-", 
        RowBox[{"5", " ", "s", " ", "uc"}], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["s", "2"], " ", 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
           RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "-", 
        RowBox[{"2", " ", "aw", " ", "s", " ", "\[Alpha]"}], "+", 
        RowBox[{"2", " ", "k", " ", 
         SuperscriptBox["s", "2"], " ", "u", " ", "\[Alpha]"}], "+", 
        RowBox[{"2", " ", "s", " ", "uc", " ", "\[Alpha]"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["s", "2"], " ", 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
           RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Alpha]"}], 
        "+", 
        RowBox[{"7", " ", 
         SuperscriptBox["c", "2"], " ", "k", " ", "u", " ", "\[Beta]"}], "-", 
        
        RowBox[{"7", " ", "c", " ", "us", " ", "\[Beta]"}], "+", 
        RowBox[{"7", " ", 
         SuperscriptBox["c", "2"], " ", 
         SqrtBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
           RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Beta]"}]}], 
       RowBox[{"7", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["c", "2"], "+", 
          SuperscriptBox["s", "2"]}], ")"}]}]], "-", 
      RowBox[{"\[Sqrt]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "g", " ", "k", " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", 
            FractionBox[
             RowBox[{"u", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "k"}], " ", "u"}], "+", "v", "-", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
                  RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], ")"}]}], 
             "g"]}], ")"}]}], "+", 
         FractionBox[
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "aw", " ", "s"}], "-", 
             RowBox[{"5", " ", "k", " ", 
              SuperscriptBox["s", "2"], " ", "u"}], "-", 
             RowBox[{"5", " ", "s", " ", "uc"}], "-", 
             RowBox[{"5", " ", 
              SuperscriptBox["s", "2"], " ", 
              SqrtBox[
               RowBox[{
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
                RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "-", 
             RowBox[{"2", " ", "aw", " ", "s", " ", "\[Alpha]"}], "+", 
             RowBox[{"2", " ", "k", " ", 
              SuperscriptBox["s", "2"], " ", "u", " ", "\[Alpha]"}], "+", 
             RowBox[{"2", " ", "s", " ", "uc", " ", "\[Alpha]"}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["s", "2"], " ", 
              SqrtBox[
               RowBox[{
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
                RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
              "\[Alpha]"}], "+", 
             RowBox[{"7", " ", 
              SuperscriptBox["c", "2"], " ", "k", " ", "u", " ", "\[Beta]"}], 
             "-", 
             RowBox[{"7", " ", "c", " ", "us", " ", "\[Beta]"}], "+", 
             RowBox[{"7", " ", 
              SuperscriptBox["c", "2"], " ", 
              SqrtBox[
               RowBox[{
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
                RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
              "\[Beta]"}]}], ")"}], "2"], 
          RowBox[{"49", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "2"], "+", 
              SuperscriptBox["s", "2"]}], ")"}], "2"]}]]}], ")"}]}]}], 
     ")"}]}]}]}]], "Output",
 CellChangeTimes->{3.672020474722389*^9}],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"\[Sqrt]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "g", " ", "k", " ", 
      RowBox[{"(", 
       RowBox[{"x", "+", 
        FractionBox[
         RowBox[{"u", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "k"}], " ", "u"}], "+", "v", "-", 
            SqrtBox[
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
              RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], ")"}]}], 
         "g"]}], ")"}]}], "+", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "aw", " ", "s"}], "-", 
         RowBox[{"5", " ", "k", " ", 
          SuperscriptBox["s", "2"], " ", "u"}], "-", 
         RowBox[{"5", " ", "s", " ", "uc"}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["s", "2"], " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
            RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "-", 
         RowBox[{"2", " ", "aw", " ", "s", " ", "\[Alpha]"}], "+", 
         RowBox[{"2", " ", "k", " ", 
          SuperscriptBox["s", "2"], " ", "u", " ", "\[Alpha]"}], "+", 
         RowBox[{"2", " ", "s", " ", "uc", " ", "\[Alpha]"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["s", "2"], " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
            RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Alpha]"}],
          "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["c", "2"], " ", "k", " ", "u", " ", "\[Beta]"}], "-", 
         RowBox[{"7", " ", "c", " ", "us", " ", "\[Beta]"}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["c", "2"], " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
            RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
          "\[Beta]"}]}], ")"}], "2"], 
      RowBox[{"49", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["c", "2"], "+", 
          SuperscriptBox["s", "2"]}], ")"}], "2"]}]]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.672020474725172*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"n", "+", 
       RowBox[{"m", "*", "a"}]}], "\[Equal]", 
      RowBox[{
       RowBox[{"-", "\[Alpha]"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"u", "[", "2", "]"}], "+", 
         RowBox[{"a", "*", 
          RowBox[{"w", "[", "1", "]"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "m", "*", "a"}], "-", 
       RowBox[{"5", "n"}]}], "\[Equal]", 
      RowBox[{
       RowBox[{"2", "a", "*", 
        RowBox[{"w", "[", "1", "]"}]}], "-", 
       RowBox[{"5", 
        RowBox[{"u", "[", "2", "]"}]}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "m"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.672020489844284*^9, 3.672020509434354*^9}, {
  3.672020545644611*^9, 3.67202072018953*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"n", "\[Rule]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"7", " ", "a"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            FractionBox["2", "7"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", "aw"}], "-", 
              RowBox[{"5", " ", "k", " ", "s", " ", "u"}], "-", 
              RowBox[{"5", " ", "uc"}], "-", 
              RowBox[{"5", " ", "s", " ", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
                 RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "+", 
              RowBox[{"5", " ", "aw", " ", "\[Alpha]"}], "-", 
              RowBox[{"5", " ", "k", " ", "s", " ", "u", " ", "\[Alpha]"}], 
              "-", 
              RowBox[{"5", " ", "uc", " ", "\[Alpha]"}], "-", 
              RowBox[{"5", " ", "s", " ", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
                 RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
               "\[Alpha]"}]}], ")"}]}], "-", 
           FractionBox[
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", "aw", " ", "c"}], "-", 
               RowBox[{"5", " ", "c", " ", "k", " ", "s", " ", "u"}], "-", 
               RowBox[{"5", " ", "c", " ", "uc"}], "-", 
               RowBox[{"5", " ", "c", " ", "s", " ", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
                  RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "-", 
               RowBox[{"2", " ", "aw", " ", "c", " ", "\[Alpha]"}], "+", 
               RowBox[{
               "2", " ", "c", " ", "k", " ", "s", " ", "u", " ", "\[Alpha]"}],
                "+", 
               RowBox[{"2", " ", "c", " ", "uc", " ", "\[Alpha]"}], "+", 
               RowBox[{"2", " ", "c", " ", "s", " ", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
                  RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
                "\[Alpha]"}], "-", 
               RowBox[{
               "7", " ", "c", " ", "k", " ", "s", " ", "u", " ", "\[Beta]"}], 
               "+", 
               RowBox[{"7", " ", "s", " ", "us", " ", "\[Beta]"}], "-", 
               RowBox[{"7", " ", "c", " ", "s", " ", 
                SqrtBox[
                 RowBox[{
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
                  RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
                "\[Beta]"}]}], ")"}]}], 
            RowBox[{"7", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["c", "2"], "+", 
               SuperscriptBox["s", "2"]}], ")"}]}]]}], ")"}]}], "-", 
        RowBox[{"2", " ", "a", " ", "\[Alpha]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            FractionBox["1", "7"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "aw"}], "+", 
              RowBox[{"5", " ", "k", " ", "s", " ", "u"}], "+", 
              RowBox[{"5", " ", "uc"}], "+", 
              RowBox[{"5", " ", "s", " ", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
                 RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "-", 
              RowBox[{"5", " ", "aw", " ", "\[Alpha]"}], "+", 
              RowBox[{"5", " ", "k", " ", "s", " ", "u", " ", "\[Alpha]"}], 
              "+", 
              RowBox[{"5", " ", "uc", " ", "\[Alpha]"}], "+", 
              RowBox[{"5", " ", "s", " ", 
               SqrtBox[
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
                 RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
               "\[Alpha]"}]}], ")"}]}], "-", 
           FractionBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", "aw", " ", "c"}], "-", 
             RowBox[{"5", " ", "c", " ", "k", " ", "s", " ", "u"}], "-", 
             RowBox[{"5", " ", "c", " ", "uc"}], "-", 
             RowBox[{"5", " ", "c", " ", "s", " ", 
              SqrtBox[
               RowBox[{
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
                RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "-", 
             RowBox[{"2", " ", "aw", " ", "c", " ", "\[Alpha]"}], "+", 
             RowBox[{
             "2", " ", "c", " ", "k", " ", "s", " ", "u", " ", "\[Alpha]"}], 
             "+", 
             RowBox[{"2", " ", "c", " ", "uc", " ", "\[Alpha]"}], "+", 
             RowBox[{"2", " ", "c", " ", "s", " ", 
              SqrtBox[
               RowBox[{
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
                RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
              "\[Alpha]"}], "-", 
             RowBox[{
             "7", " ", "c", " ", "k", " ", "s", " ", "u", " ", "\[Beta]"}], 
             "+", 
             RowBox[{"7", " ", "s", " ", "us", " ", "\[Beta]"}], "-", 
             RowBox[{"7", " ", "c", " ", "s", " ", 
              SqrtBox[
               RowBox[{
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
                RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
              "\[Beta]"}]}], 
            RowBox[{"7", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["c", "2"], "+", 
               SuperscriptBox["s", "2"]}], ")"}]}]]}], ")"}]}]}], ")"}]}]}], 
    ",", 
    RowBox[{"m", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"49", " ", "a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           SuperscriptBox["s", "2"]}], ")"}]}]], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"10", " ", "aw", " ", "c"}], "-", 
         RowBox[{"4", " ", "aw", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"4", " ", "aw", " ", 
          SuperscriptBox["s", "2"]}], "+", 
         RowBox[{"25", " ", "c", " ", "k", " ", "s", " ", "u"}], "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "2"], " ", "k", " ", "s", " ", "u"}], "-", 
         RowBox[{"10", " ", "k", " ", 
          SuperscriptBox["s", "3"], " ", "u"}], "+", 
         RowBox[{"25", " ", "c", " ", "uc"}], "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "2"], " ", "uc"}], "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["s", "2"], " ", "uc"}], "+", 
         RowBox[{"25", " ", "c", " ", "s", " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
            RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "2"], " ", "s", " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
            RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["s", "3"], " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
            RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]]}], "+", 
         RowBox[{"20", " ", "aw", " ", "c", " ", "\[Alpha]"}], "+", 
         RowBox[{"20", " ", "aw", " ", 
          SuperscriptBox["c", "2"], " ", "\[Alpha]"}], "+", 
         RowBox[{"20", " ", "aw", " ", 
          SuperscriptBox["s", "2"], " ", "\[Alpha]"}], "+", 
         RowBox[{
         "15", " ", "c", " ", "k", " ", "s", " ", "u", " ", "\[Alpha]"}], "+", 
         RowBox[{"15", " ", 
          SuperscriptBox["c", "2"], " ", "k", " ", "s", " ", "u", " ", 
          "\[Alpha]"}], "+", 
         RowBox[{"15", " ", "k", " ", 
          SuperscriptBox["s", "3"], " ", "u", " ", "\[Alpha]"}], "+", 
         RowBox[{"15", " ", "c", " ", "uc", " ", "\[Alpha]"}], "+", 
         RowBox[{"15", " ", 
          SuperscriptBox["c", "2"], " ", "uc", " ", "\[Alpha]"}], "+", 
         RowBox[{"15", " ", 
          SuperscriptBox["s", "2"], " ", "uc", " ", "\[Alpha]"}], "+", 
         RowBox[{"15", " ", "c", " ", "s", " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
            RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Alpha]"}],
          "+", 
         RowBox[{"15", " ", 
          SuperscriptBox["c", "2"], " ", "s", " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
            RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Alpha]"}],
          "+", 
         RowBox[{"15", " ", 
          SuperscriptBox["s", "3"], " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
            RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Alpha]"}],
          "+", 
         RowBox[{"10", " ", "aw", " ", "c", " ", 
          SuperscriptBox["\[Alpha]", "2"]}], "-", 
         RowBox[{"25", " ", "aw", " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["\[Alpha]", "2"]}], "-", 
         RowBox[{"25", " ", "aw", " ", 
          SuperscriptBox["s", "2"], " ", 
          SuperscriptBox["\[Alpha]", "2"]}], "-", 
         RowBox[{"10", " ", "c", " ", "k", " ", "s", " ", "u", " ", 
          SuperscriptBox["\[Alpha]", "2"]}], "+", 
         RowBox[{"25", " ", 
          SuperscriptBox["c", "2"], " ", "k", " ", "s", " ", "u", " ", 
          SuperscriptBox["\[Alpha]", "2"]}], "+", 
         RowBox[{"25", " ", "k", " ", 
          SuperscriptBox["s", "3"], " ", "u", " ", 
          SuperscriptBox["\[Alpha]", "2"]}], "-", 
         RowBox[{"10", " ", "c", " ", "uc", " ", 
          SuperscriptBox["\[Alpha]", "2"]}], "+", 
         RowBox[{"25", " ", 
          SuperscriptBox["c", "2"], " ", "uc", " ", 
          SuperscriptBox["\[Alpha]", "2"]}], "+", 
         RowBox[{"25", " ", 
          SuperscriptBox["s", "2"], " ", "uc", " ", 
          SuperscriptBox["\[Alpha]", "2"]}], "-", 
         RowBox[{"10", " ", "c", " ", "s", " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
            RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
          SuperscriptBox["\[Alpha]", "2"]}], "+", 
         RowBox[{"25", " ", 
          SuperscriptBox["c", "2"], " ", "s", " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
            RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
          SuperscriptBox["\[Alpha]", "2"]}], "+", 
         RowBox[{"25", " ", 
          SuperscriptBox["s", "3"], " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
            RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", 
          SuperscriptBox["\[Alpha]", "2"]}], "+", 
         RowBox[{
         "35", " ", "c", " ", "k", " ", "s", " ", "u", " ", "\[Beta]"}], "-", 
         
         RowBox[{"35", " ", "s", " ", "us", " ", "\[Beta]"}], "+", 
         RowBox[{"35", " ", "c", " ", "s", " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
            RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Beta]"}], 
         "+", 
         RowBox[{
         "35", " ", "c", " ", "k", " ", "s", " ", "u", " ", "\[Alpha]", " ", 
          "\[Beta]"}], "-", 
         RowBox[{"35", " ", "s", " ", "us", " ", "\[Alpha]", " ", "\[Beta]"}],
          "+", 
         RowBox[{"35", " ", "c", " ", "s", " ", 
          SqrtBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"k", " ", "u"}], "-", "v"}], ")"}], "2"], "-", 
            RowBox[{"2", " ", "g", " ", "k", " ", "x"}]}]], " ", "\[Alpha]", 
          " ", "\[Beta]"}]}], ")"}]}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.672020738406227*^9}]
}, Open  ]]
},
WindowSize->{Full, Full},
WindowMargins->{{4, Automatic}, {Automatic, 4}},
FrontEndVersion->"10.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (March 23, \
2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 578, 17, 28, "Input"],
Cell[1161, 41, 976, 31, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2174, 77, 587, 19, 70, "Input"],
Cell[2764, 98, 541, 18, 78, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3342, 121, 514, 17, 62, "Input"],
Cell[3859, 140, 303, 10, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4199, 155, 520, 16, 35, "Input"],
Cell[4722, 173, 893, 28, 43, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5652, 206, 798, 25, 70, "Input"],
Cell[6453, 233, 371, 12, 40, "Output"],
Cell[6827, 247, 354, 11, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7218, 263, 886, 26, 35, "Input"],
Cell[8107, 291, 2763, 75, 96, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10907, 371, 2580, 72, 147, "Input"],
Cell[13490, 445, 987, 28, 58, "Output"],
Cell[14480, 475, 974, 28, 47, "Output"],
Cell[15457, 505, 421, 13, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15915, 523, 582, 17, 35, "Input"],
Cell[16500, 542, 3793, 100, 120, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20330, 647, 3491, 97, 125, "Input"],
Cell[23824, 746, 1607, 44, 63, "Output"],
Cell[25434, 792, 1699, 48, 63, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27170, 845, 543, 17, 48, "Input"],
Cell[27716, 864, 10605, 261, 471, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38358, 1130, 4798, 128, 263, "Input"],
Cell[43159, 1260, 4748, 127, 236, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47944, 1392, 372, 11, 46, "Input"],
Cell[48319, 1405, 6909, 186, 338, "Output"],
Cell[55231, 1593, 2662, 73, 160, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57930, 1671, 858, 27, 28, "Input"],
Cell[58791, 1700, 14228, 346, 424, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

